@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GlobalParameterSpecificationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.GlobalParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of a single parameter for an entity.
 * @property type Global Parameter type.
 * @property value Value of parameter.
 */
public data class GlobalParameterSpecificationArgs(
    public val type: Output<Either<String, GlobalParameterType>>,
    public val `value`: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GlobalParameterSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GlobalParameterSpecificationArgs =
        com.pulumi.azurenative.datafactory.inputs.GlobalParameterSpecificationArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalParameterSpecificationArgs].
 */
@PulumiTagMarker
public class GlobalParameterSpecificationArgsBuilder internal constructor() {
    private var type: Output<Either<String, GlobalParameterType>>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Global Parameter type.
     */
    @JvmName("woyauqtgucehbdnk")
    public suspend fun type(`value`: Output<Either<String, GlobalParameterType>>) {
        this.type = value
    }

    /**
     * @param value Value of parameter.
     */
    @JvmName("vytwhmbpwtscrfxk")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Global Parameter type.
     */
    @JvmName("pkdgqtmwywrxijua")
    public suspend fun type(`value`: Either<String, GlobalParameterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Global Parameter type.
     */
    @JvmName("vrdnrtouuosfkogd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GlobalParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Global Parameter type.
     */
    @JvmName("cgglbibwsoqfboqt")
    public fun type(`value`: GlobalParameterType) {
        val toBeMapped = Either.ofRight<String, GlobalParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of parameter.
     */
    @JvmName("bejjdqoqplepefpi")
    public suspend fun `value`(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GlobalParameterSpecificationArgs = GlobalParameterSpecificationArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
