@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GoogleCloudStorageLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of Google Cloud Storage dataset.
 * @property bucketName Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'GoogleCloudStorageLocation'.
 * @property version Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string).
 */
public data class GoogleCloudStorageLocationArgs(
    public val bucketName: Output<Any>? = null,
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
    public val version: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GoogleCloudStorageLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GoogleCloudStorageLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.GoogleCloudStorageLocationArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GoogleCloudStorageLocationArgs].
 */
@PulumiTagMarker
public class GoogleCloudStorageLocationArgsBuilder internal constructor() {
    private var bucketName: Output<Any>? = null

    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var version: Output<Any>? = null

    /**
     * @param value Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)
     */
    @JvmName("uvhbnkhwjtuxgsxy")
    public suspend fun bucketName(`value`: Output<Any>) {
        this.bucketName = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("gdengwnkcjbnposf")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("ebnebrhvpuvxhhaj")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'GoogleCloudStorageLocation'.
     */
    @JvmName("pjrwjtnryvrkqwqm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string).
     */
    @JvmName("ddviljrpradmbfug")
    public suspend fun version(`value`: Output<Any>) {
        this.version = value
    }

    /**
     * @param value Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)
     */
    @JvmName("hjrertgkgmmyxijx")
    public suspend fun bucketName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("xftcsstbeofiveoi")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("gqwmcitmcgjorjqn")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'GoogleCloudStorageLocation'.
     */
    @JvmName("yrcboqyqmhkpfqcw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string).
     */
    @JvmName("qdikxmqxdwphruui")
    public suspend fun version(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GoogleCloudStorageLocationArgs = GoogleCloudStorageLocationArgs(
        bucketName = bucketName,
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
