@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HDFS read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property distcpSettings Specifies Distcp-related settings.
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'HdfsReadSettings'.
 * @property wildcardFileName HDFS wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class HdfsReadSettingsArgs(
    public val deleteFilesAfterCompletion: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val distcpSettings: Output<DistcpSettingsArgs>? = null,
    public val enablePartitionDiscovery: Output<Any>? = null,
    public val fileListPath: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val partitionRootPath: Output<Any>? = null,
    public val recursive: Output<Any>? = null,
    public val type: Output<String>,
    public val wildcardFileName: Output<Any>? = null,
    public val wildcardFolderPath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs.builder()
            .deleteFilesAfterCompletion(deleteFilesAfterCompletion?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .distcpSettings(distcpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enablePartitionDiscovery(enablePartitionDiscovery?.applyValue({ args0 -> args0 }))
            .fileListPath(fileListPath?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .partitionRootPath(partitionRootPath?.applyValue({ args0 -> args0 }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .wildcardFileName(wildcardFileName?.applyValue({ args0 -> args0 }))
            .wildcardFolderPath(wildcardFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HdfsReadSettingsArgs].
 */
@PulumiTagMarker
public class HdfsReadSettingsArgsBuilder internal constructor() {
    private var deleteFilesAfterCompletion: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var distcpSettings: Output<DistcpSettingsArgs>? = null

    private var enablePartitionDiscovery: Output<Any>? = null

    private var fileListPath: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var partitionRootPath: Output<Any>? = null

    private var recursive: Output<Any>? = null

    private var type: Output<String>? = null

    private var wildcardFileName: Output<Any>? = null

    private var wildcardFolderPath: Output<Any>? = null

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("obqtidgkhtwqjjun")
    public suspend fun deleteFilesAfterCompletion(`value`: Output<Any>) {
        this.deleteFilesAfterCompletion = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("cxnassapoadjdgph")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Specifies Distcp-related settings.
     */
    @JvmName("riegmvehtxnjonnd")
    public suspend fun distcpSettings(`value`: Output<DistcpSettingsArgs>) {
        this.distcpSettings = value
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xptpadwufeyjifnb")
    public suspend fun enablePartitionDiscovery(`value`: Output<Any>) {
        this.enablePartitionDiscovery = value
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("jwhvjukrxqhvqlor")
    public suspend fun fileListPath(`value`: Output<Any>) {
        this.fileListPath = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("glmythjglusqhrtf")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("ieubsbityineinur")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("uffbuculrqawaokd")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("gvnmlsyuayhuftkl")
    public suspend fun partitionRootPath(`value`: Output<Any>) {
        this.partitionRootPath = value
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pjudfhewdbetrfkh")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HdfsReadSettings'.
     */
    @JvmName("roaoeawfdmnlgrrr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value HDFS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("rtuvpwoeilshoxcl")
    public suspend fun wildcardFileName(`value`: Output<Any>) {
        this.wildcardFileName = value
    }

    /**
     * @param value HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("jjowumtilhierbsa")
    public suspend fun wildcardFolderPath(`value`: Output<Any>) {
        this.wildcardFolderPath = value
    }

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("utdhesmxsyrxaipv")
    public suspend fun deleteFilesAfterCompletion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteFilesAfterCompletion = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tgvclmmyqaugvgny")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Specifies Distcp-related settings.
     */
    @JvmName("guinatksvawbjvek")
    public suspend fun distcpSettings(`value`: DistcpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distcpSettings = mapped
    }

    /**
     * @param argument Specifies Distcp-related settings.
     */
    @JvmName("wwutbvqstyyjnowt")
    public suspend fun distcpSettings(argument: suspend DistcpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DistcpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.distcpSettings = mapped
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xakihbkmhpamejdk")
    public suspend fun enablePartitionDiscovery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionDiscovery = mapped
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("ympenodilyrcmnft")
    public suspend fun fileListPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileListPath = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jnemjpddmifxgmby")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("skmkhatuxnbejnwp")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("aritgwglxpxjqguy")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("smoxabtirdajjfos")
    public suspend fun partitionRootPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionRootPath = mapped
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("aqvbmhkpoehdcfub")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HdfsReadSettings'.
     */
    @JvmName("buoquonjfoyqkqdu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value HDFS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("spviobuxlnoyqpdp")
    public suspend fun wildcardFileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFileName = mapped
    }

    /**
     * @param value HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("hdrighefmbcsnqdq")
    public suspend fun wildcardFolderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFolderPath = mapped
    }

    internal fun build(): HdfsReadSettingsArgs = HdfsReadSettingsArgs(
        deleteFilesAfterCompletion = deleteFilesAfterCompletion,
        disableMetricsCollection = disableMetricsCollection,
        distcpSettings = distcpSettings,
        enablePartitionDiscovery = enablePartitionDiscovery,
        fileListPath = fileListPath,
        maxConcurrentConnections = maxConcurrentConnections,
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        partitionRootPath = partitionRootPath,
        recursive = recursive,
        type = type ?: throw PulumiNullFieldException("type"),
        wildcardFileName = wildcardFileName,
        wildcardFolderPath = wildcardFolderPath,
    )
}
