@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomerVirtualNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The definition and properties of virtual network to which Azure-SSIS integration runtime will join.
 * @property subnetId The ID of subnet to which Azure-SSIS integration runtime will join.
 */
public data class IntegrationRuntimeCustomerVirtualNetworkArgs(
    public val subnetId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomerVirtualNetworkArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomerVirtualNetworkArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomerVirtualNetworkArgs.builder()
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeCustomerVirtualNetworkArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeCustomerVirtualNetworkArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of subnet to which Azure-SSIS integration runtime will join.
     */
    @JvmName("tkrwwlimweubrqsu")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of subnet to which Azure-SSIS integration runtime will join.
     */
    @JvmName("iprohwadqqpyukby")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): IntegrationRuntimeCustomerVirtualNetworkArgs =
        IntegrationRuntimeCustomerVirtualNetworkArgs(
            subnetId = subnetId,
        )
}
