@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LakeHouseReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Microsoft Fabric LakeHouse Files read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'LakeHouseReadSettings'.
 * @property wildcardFileName Microsoft Fabric LakeHouse Files wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath Microsoft Fabric LakeHouse Files wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class LakeHouseReadSettingsArgs(
    public val deleteFilesAfterCompletion: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val enablePartitionDiscovery: Output<Any>? = null,
    public val fileListPath: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val partitionRootPath: Output<Any>? = null,
    public val recursive: Output<Any>? = null,
    public val type: Output<String>,
    public val wildcardFileName: Output<Any>? = null,
    public val wildcardFolderPath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LakeHouseReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LakeHouseReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.LakeHouseReadSettingsArgs.builder()
            .deleteFilesAfterCompletion(deleteFilesAfterCompletion?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .enablePartitionDiscovery(enablePartitionDiscovery?.applyValue({ args0 -> args0 }))
            .fileListPath(fileListPath?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .partitionRootPath(partitionRootPath?.applyValue({ args0 -> args0 }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .wildcardFileName(wildcardFileName?.applyValue({ args0 -> args0 }))
            .wildcardFolderPath(wildcardFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeHouseReadSettingsArgs].
 */
@PulumiTagMarker
public class LakeHouseReadSettingsArgsBuilder internal constructor() {
    private var deleteFilesAfterCompletion: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var enablePartitionDiscovery: Output<Any>? = null

    private var fileListPath: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var partitionRootPath: Output<Any>? = null

    private var recursive: Output<Any>? = null

    private var type: Output<String>? = null

    private var wildcardFileName: Output<Any>? = null

    private var wildcardFolderPath: Output<Any>? = null

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("atwfxfxejmnxxxql")
    public suspend fun deleteFilesAfterCompletion(`value`: Output<Any>) {
        this.deleteFilesAfterCompletion = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fhrbmqolxbkitruh")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mmoivsubykaihkud")
    public suspend fun enablePartitionDiscovery(`value`: Output<Any>) {
        this.enablePartitionDiscovery = value
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("owyybtqadyrtmkty")
    public suspend fun fileListPath(`value`: Output<Any>) {
        this.fileListPath = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mygrfpqkjnwlbcmu")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("wxfgbtucqeqhigpp")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("kooxapxhouhubchk")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("dsleuxgrjavyjvsr")
    public suspend fun partitionRootPath(`value`: Output<Any>) {
        this.partitionRootPath = value
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lvhhlbiujnglxfyg")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'LakeHouseReadSettings'.
     */
    @JvmName("yohhgcibimwwdgsb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Microsoft Fabric LakeHouse Files wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("bwdxfpdsbfgrnjpt")
    public suspend fun wildcardFileName(`value`: Output<Any>) {
        this.wildcardFileName = value
    }

    /**
     * @param value Microsoft Fabric LakeHouse Files wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("avtomvwbawmfvjla")
    public suspend fun wildcardFolderPath(`value`: Output<Any>) {
        this.wildcardFolderPath = value
    }

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pouemgrupgduemlp")
    public suspend fun deleteFilesAfterCompletion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteFilesAfterCompletion = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("cywcpbgjjxktnwcg")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nojkxpbgrkerwobf")
    public suspend fun enablePartitionDiscovery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionDiscovery = mapped
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("shiiixbgdpuvqhkc")
    public suspend fun fileListPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileListPath = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("wupoymrskatfvhcm")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("wcwpjkrriyptbsgb")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("apfpnfwupebdpheb")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("mjxthngahaskyyjg")
    public suspend fun partitionRootPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionRootPath = mapped
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ypryavlunmrpmllw")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'LakeHouseReadSettings'.
     */
    @JvmName("hocriefrdvmwdaja")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Microsoft Fabric LakeHouse Files wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("jjaytmipvhbxoalu")
    public suspend fun wildcardFileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFileName = mapped
    }

    /**
     * @param value Microsoft Fabric LakeHouse Files wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("pdtakeejkldejgml")
    public suspend fun wildcardFolderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFolderPath = mapped
    }

    internal fun build(): LakeHouseReadSettingsArgs = LakeHouseReadSettingsArgs(
        deleteFilesAfterCompletion = deleteFilesAfterCompletion,
        disableMetricsCollection = disableMetricsCollection,
        enablePartitionDiscovery = enablePartitionDiscovery,
        fileListPath = fileListPath,
        maxConcurrentConnections = maxConcurrentConnections,
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        partitionRootPath = partitionRootPath,
        recursive = recursive,
        type = type ?: throw PulumiNullFieldException("type"),
        wildcardFileName = wildcardFileName,
        wildcardFolderPath = wildcardFolderPath,
    )
}
