@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LakeHouseTableSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity source for Microsoft Fabric LakeHouse Table.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property timestampAsOf Query an older snapshot by timestamp. Type: string (or Expression with resultType string).
 * @property type Copy source type.
 * Expected value is 'LakeHouseTableSource'.
 * @property versionAsOf Query an older snapshot by version. Type: integer (or Expression with resultType integer).
 */
public data class LakeHouseTableSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val timestampAsOf: Output<Any>? = null,
    public val type: Output<String>,
    public val versionAsOf: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LakeHouseTableSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LakeHouseTableSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.LakeHouseTableSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .timestampAsOf(timestampAsOf?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .versionAsOf(versionAsOf?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeHouseTableSourceArgs].
 */
@PulumiTagMarker
public class LakeHouseTableSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var timestampAsOf: Output<Any>? = null

    private var type: Output<String>? = null

    private var versionAsOf: Output<Any>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("cljxdcmwajofxpye")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lqrkcyaytfwiojsx")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("uyqqckfsjbndslkk")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qfvdjtgnldvsvsqt")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("fksglkweqawsrxqe")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Query an older snapshot by timestamp. Type: string (or Expression with resultType string).
     */
    @JvmName("mcaglrmirufmgqqo")
    public suspend fun timestampAsOf(`value`: Output<Any>) {
        this.timestampAsOf = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'LakeHouseTableSource'.
     */
    @JvmName("fqyeecvygtebjbws")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Query an older snapshot by version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jqfclvytxrnpnqje")
    public suspend fun versionAsOf(`value`: Output<Any>) {
        this.versionAsOf = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("epaoebydpvahjeuf")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wiyasoduxncvnxnm")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jttvlgrcmvtialhh")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ogkwqohqaoddcker")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ddelrepqtfxhfrpe")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Query an older snapshot by timestamp. Type: string (or Expression with resultType string).
     */
    @JvmName("wblfwqxqjeffgxqv")
    public suspend fun timestampAsOf(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampAsOf = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'LakeHouseTableSource'.
     */
    @JvmName("tiixbluliyevbyml")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Query an older snapshot by version. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mpehiyilweuywvie")
    public suspend fun versionAsOf(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionAsOf = mapped
    }

    internal fun build(): LakeHouseTableSourceArgs = LakeHouseTableSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        timestampAsOf = timestampAsOf,
        type = type ?: throw PulumiNullFieldException("type"),
        versionAsOf = versionAsOf,
    )
}
