@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LakeHouseWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Microsoft Fabric LakeHouse Files write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'LakeHouseWriteSettings'.
 */
public data class LakeHouseWriteSettingsArgs(
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LakeHouseWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LakeHouseWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.LakeHouseWriteSettingsArgs.builder()
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeHouseWriteSettingsArgs].
 */
@PulumiTagMarker
public class LakeHouseWriteSettingsArgsBuilder internal constructor() {
    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("txooeghtytvdsxhc")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mavcomykgoacusgm")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rqxbfwgjhfhhedrs")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'LakeHouseWriteSettings'.
     */
    @JvmName("yyaylbtvwrlnvjty")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("kmoqdbbxarkewaaa")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fphxjqymuqjguomd")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ontxetkmpxxtibgs")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'LakeHouseWriteSettings'.
     */
    @JvmName("tdycqdmvfupaayke")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LakeHouseWriteSettingsArgs = LakeHouseWriteSettingsArgs(
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
