@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The role based access control (RBAC) authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'RBAC'.
 * @property credential The credential reference containing authentication information.
 * @property resourceId The resource identifier of the integration runtime to be shared.
 */
public data class LinkedIntegrationRuntimeRbacAuthorizationArgs(
    public val authorizationType: Output<String>,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val resourceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs =
        com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs.builder()
            .authorizationType(authorizationType.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedIntegrationRuntimeRbacAuthorizationArgs].
 */
@PulumiTagMarker
public class LinkedIntegrationRuntimeRbacAuthorizationArgsBuilder internal constructor() {
    private var authorizationType: Output<String>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'RBAC'.
     */
    @JvmName("pqajghwtcdesmbmx")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("cyoeopirfwprkyfp")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value The resource identifier of the integration runtime to be shared.
     */
    @JvmName("jinmyglxxrqywvpr")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'RBAC'.
     */
    @JvmName("wwrjywtrkbxdxwhn")
    public suspend fun authorizationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ifixqrqiaaebubmv")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("vywbxleuvqceveax")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The resource identifier of the integration runtime to be shared.
     */
    @JvmName("nytcmmpdrpysotvh")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): LinkedIntegrationRuntimeRbacAuthorizationArgs =
        LinkedIntegrationRuntimeRbacAuthorizationArgs(
            authorizationType = authorizationType ?: throw PulumiNullFieldException("authorizationType"),
            credential = credential,
            resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        )
}
