@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LogLocationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Log location settings.
 * @property linkedServiceName Log storage linked service reference.
 * @property path The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
 */
public data class LogLocationSettingsArgs(
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val path: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LogLocationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LogLocationSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.LogLocationSettingsArgs.builder()
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogLocationSettingsArgs].
 */
@PulumiTagMarker
public class LogLocationSettingsArgsBuilder internal constructor() {
    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var path: Output<Any>? = null

    /**
     * @param value Log storage linked service reference.
     */
    @JvmName("ypayywgknbunwcxm")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
     */
    @JvmName("homjyuxmltnpfnbs")
    public suspend fun path(`value`: Output<Any>) {
        this.path = value
    }

    /**
     * @param value Log storage linked service reference.
     */
    @JvmName("sunqrggvthxquuaq")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Log storage linked service reference.
     */
    @JvmName("btxyfhacpxalgnpk")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
     */
    @JvmName("fqbaaqqyqxgguidj")
    public suspend fun path(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): LogLocationSettingsArgs = LogLocationSettingsArgs(
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        path = path,
    )
}
