@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ManagedPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a managed private endpoint
 * @property fqdns Fully qualified domain names
 * @property groupId The groupId to which the managed private endpoint is created
 * @property privateLinkResourceId The ARM resource ID of the resource to which the managed private endpoint is created
 */
public data class ManagedPrivateEndpointArgs(
    public val fqdns: Output<List<String>>? = null,
    public val groupId: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ManagedPrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ManagedPrivateEndpointArgs =
        com.pulumi.azurenative.datafactory.inputs.ManagedPrivateEndpointArgs.builder()
            .fqdns(fqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrivateEndpointArgs].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointArgsBuilder internal constructor() {
    private var fqdns: Output<List<String>>? = null

    private var groupId: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    /**
     * @param value Fully qualified domain names
     */
    @JvmName("qtrjbqcxyuqsjuus")
    public suspend fun fqdns(`value`: Output<List<String>>) {
        this.fqdns = value
    }

    @JvmName("iblfbmnyykgistdo")
    public suspend fun fqdns(vararg values: Output<String>) {
        this.fqdns = Output.all(values.asList())
    }

    /**
     * @param values Fully qualified domain names
     */
    @JvmName("bfpusorwffcjjhcc")
    public suspend fun fqdns(values: List<Output<String>>) {
        this.fqdns = Output.all(values)
    }

    /**
     * @param value The groupId to which the managed private endpoint is created
     */
    @JvmName("wcguqpxicxhqhwpd")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The ARM resource ID of the resource to which the managed private endpoint is created
     */
    @JvmName("uvapyacqkefwtrwe")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value Fully qualified domain names
     */
    @JvmName("ydwibrdsyuuvurdd")
    public suspend fun fqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param values Fully qualified domain names
     */
    @JvmName("wxebhjmliabbonua")
    public suspend fun fqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param value The groupId to which the managed private endpoint is created
     */
    @JvmName("vojojgubfciwxqnp")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ARM resource ID of the resource to which the managed private endpoint is created
     */
    @JvmName("bciqcmbltwgbskef")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    internal fun build(): ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs(
        fqdns = fqdns,
        groupId = groupId,
        privateLinkResourceId = privateLinkResourceId,
    )
}
