@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MongoDbV2LinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for MongoDB data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'MongoDbV2'.
 */
public data class MongoDbV2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>,
    public val database: Output<Any>,
    public val description: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MongoDbV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MongoDbV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.MongoDbV2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .database(database.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class MongoDbV2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("tbcrwgxnjvyvyasg")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("euldcxgsquxdwtuq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("aacmqjefxvwbxror")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mstfwepoebvaxeiv")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("sjhtlxgawctmyupb")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("rvbvstfjxplahwly")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("jjrxanocqiwsoeqq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("epcuufvcvbkkyviv")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MongoDbV2'.
     */
    @JvmName("bkqrhafipfksxtph")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("athwmqdmclepdrni")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("qqwrehqfrujacblf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("qdmhqjigfimqnsxn")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ujacinvckmgdlmqy")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("vgspipwnhhpkrxgr")
    public suspend fun connectionString(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
     */
    @JvmName("fayakbbsrgjpofjt")
    public suspend fun database(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("jrnauhgqvksvttsi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ivrarefxejmchwcs")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ypdkmvggsnicahbn")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("cjiqplpopsgepxbx")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MongoDbV2'.
     */
    @JvmName("qwgwruxhkvimqjuy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MongoDbV2LinkedServiceArgs = MongoDbV2LinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        database = database ?: throw PulumiNullFieldException("database"),
        description = description,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
