@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MultiplePipelineTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Base class for all triggers that support one to many model for trigger to pipeline.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property pipelines Pipelines that need to be started.
 * @property type Trigger type.
 * Expected value is 'MultiplePipelineTrigger'.
 */
public data class MultiplePipelineTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MultiplePipelineTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MultiplePipelineTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.MultiplePipelineTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .pipelines(
                pipelines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiplePipelineTriggerArgs].
 */
@PulumiTagMarker
public class MultiplePipelineTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("fwppckacueowqonv")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("yqjxjkxwowemqocc")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("acjlhofnahjuhlab")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("vymcukvgdtinqsyy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("rrqlbbfmxikiorvn")
    public suspend fun pipelines(`value`: Output<List<TriggerPipelineReferenceArgs>>) {
        this.pipelines = value
    }

    @JvmName("eekcxiemifbqutkw")
    public suspend fun pipelines(vararg values: Output<TriggerPipelineReferenceArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("mxosqysuivpvnepc")
    public suspend fun pipelines(values: List<Output<TriggerPipelineReferenceArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value Trigger type.
     * Expected value is 'MultiplePipelineTrigger'.
     */
    @JvmName("xjemkkutmiwchgti")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("gljksrgdjusyrrem")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("ltciswuoxiyseogf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("xtsywhojfhosxplm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("mnihbeqbxrrehwoy")
    public suspend fun pipelines(`value`: List<TriggerPipelineReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("dtydaxxxwhefenln")
    public suspend
    fun pipelines(argument: List<suspend TriggerPipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("udsoqfpulrlsmnrv")
    public suspend fun pipelines(
        vararg
        argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("eyupvhgcuiyualoe")
    public suspend fun pipelines(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("qtnsuesuamxvkufw")
    public suspend fun pipelines(vararg values: TriggerPipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'MultiplePipelineTrigger'.
     */
    @JvmName("aawejuqrmpamjfmk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MultiplePipelineTriggerArgs = MultiplePipelineTriggerArgs(
        annotations = annotations,
        description = description,
        pipelines = pipelines,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
