@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.OrcFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data stored in Optimized Row Columnar (ORC) format.
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property type Type of dataset storage format.
 * Expected value is 'OrcFormat'.
 */
public data class OrcFormatArgs(
    public val deserializer: Output<Any>? = null,
    public val serializer: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.OrcFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.OrcFormatArgs =
        com.pulumi.azurenative.datafactory.inputs.OrcFormatArgs.builder()
            .deserializer(deserializer?.applyValue({ args0 -> args0 }))
            .serializer(serializer?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrcFormatArgs].
 */
@PulumiTagMarker
public class OrcFormatArgsBuilder internal constructor() {
    private var deserializer: Output<Any>? = null

    private var serializer: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("ixxosscowqkcawnw")
    public suspend fun deserializer(`value`: Output<Any>) {
        this.deserializer = value
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("qlhflipaemebpdhk")
    public suspend fun serializer(`value`: Output<Any>) {
        this.serializer = value
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'OrcFormat'.
     */
    @JvmName("bknbrrqrhvnxhout")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("afdwhdkkaeeqaynm")
    public suspend fun deserializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deserializer = mapped
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("plaqfmdjhgjfodxk")
    public suspend fun serializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializer = mapped
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'OrcFormat'.
     */
    @JvmName("cubjxvhapbfikqbf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OrcFormatArgs = OrcFormatArgs(
        deserializer = deserializer,
        serializer = serializer,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
