@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ParquetReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parquet read settings.
 * @property compressionProperties Compression settings.
 * @property type The read setting type.
 * Expected value is 'ParquetReadSettings'.
 */
public data class ParquetReadSettingsArgs(
    public val compressionProperties: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ParquetReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ParquetReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.ParquetReadSettingsArgs.builder()
            .compressionProperties(compressionProperties?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParquetReadSettingsArgs].
 */
@PulumiTagMarker
public class ParquetReadSettingsArgsBuilder internal constructor() {
    private var compressionProperties: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Compression settings.
     */
    @JvmName("mquintyqsmwwkajm")
    public suspend fun compressionProperties(`value`: Output<Any>) {
        this.compressionProperties = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'ParquetReadSettings'.
     */
    @JvmName("jyqpqobnldmvkkws")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Compression settings.
     */
    @JvmName("wqupwqlropojwesk")
    public suspend fun compressionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionProperties = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'ParquetReadSettings'.
     */
    @JvmName("ppykifsvpsqbkdgg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParquetReadSettingsArgs = ParquetReadSettingsArgs(
        compressionProperties = compressionProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
