@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PipelineExternalComputeScalePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * PipelineExternalComputeScale properties for managed integration runtime.
 * @property numberOfExternalNodes Number of the the external nodes, which should be greater than 0 and less than 11.
 * @property numberOfPipelineNodes Number of the pipeline nodes, which should be greater than 0 and less than 11.
 * @property timeToLive Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
 */
public data class PipelineExternalComputeScalePropertiesArgs(
    public val numberOfExternalNodes: Output<Int>? = null,
    public val numberOfPipelineNodes: Output<Int>? = null,
    public val timeToLive: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PipelineExternalComputeScalePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.PipelineExternalComputeScalePropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.PipelineExternalComputeScalePropertiesArgs.builder()
            .numberOfExternalNodes(numberOfExternalNodes?.applyValue({ args0 -> args0 }))
            .numberOfPipelineNodes(numberOfPipelineNodes?.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineExternalComputeScalePropertiesArgs].
 */
@PulumiTagMarker
public class PipelineExternalComputeScalePropertiesArgsBuilder internal constructor() {
    private var numberOfExternalNodes: Output<Int>? = null

    private var numberOfPipelineNodes: Output<Int>? = null

    private var timeToLive: Output<Int>? = null

    /**
     * @param value Number of the the external nodes, which should be greater than 0 and less than 11.
     */
    @JvmName("lslipqwqvxdqkxky")
    public suspend fun numberOfExternalNodes(`value`: Output<Int>) {
        this.numberOfExternalNodes = value
    }

    /**
     * @param value Number of the pipeline nodes, which should be greater than 0 and less than 11.
     */
    @JvmName("oifvpwfhdacjjjtk")
    public suspend fun numberOfPipelineNodes(`value`: Output<Int>) {
        this.numberOfPipelineNodes = value
    }

    /**
     * @param value Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
     */
    @JvmName("cpjklwsbnxaubwck")
    public suspend fun timeToLive(`value`: Output<Int>) {
        this.timeToLive = value
    }

    /**
     * @param value Number of the the external nodes, which should be greater than 0 and less than 11.
     */
    @JvmName("dekovytsejipqogr")
    public suspend fun numberOfExternalNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfExternalNodes = mapped
    }

    /**
     * @param value Number of the pipeline nodes, which should be greater than 0 and less than 11.
     */
    @JvmName("ynvjljrvxhkdkwxs")
    public suspend fun numberOfPipelineNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfPipelineNodes = mapped
    }

    /**
     * @param value Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
     */
    @JvmName("dvxtofqsmketnjmc")
    public suspend fun timeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    internal fun build(): PipelineExternalComputeScalePropertiesArgs =
        PipelineExternalComputeScalePropertiesArgs(
            numberOfExternalNodes = numberOfExternalNodes,
            numberOfPipelineNodes = numberOfPipelineNodes,
            timeToLive = timeToLive,
        )
}
