@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PipelinePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Pipeline Policy.
 * @property elapsedTimeMetric Pipeline ElapsedTime Metric Policy.
 */
public data class PipelinePolicyArgs(
    public val elapsedTimeMetric: Output<PipelineElapsedTimeMetricPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PipelinePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PipelinePolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.PipelinePolicyArgs.builder()
            .elapsedTimeMetric(
                elapsedTimeMetric?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelinePolicyArgs].
 */
@PulumiTagMarker
public class PipelinePolicyArgsBuilder internal constructor() {
    private var elapsedTimeMetric: Output<PipelineElapsedTimeMetricPolicyArgs>? = null

    /**
     * @param value Pipeline ElapsedTime Metric Policy.
     */
    @JvmName("edgascgbnwaftwmg")
    public suspend fun elapsedTimeMetric(`value`: Output<PipelineElapsedTimeMetricPolicyArgs>) {
        this.elapsedTimeMetric = value
    }

    /**
     * @param value Pipeline ElapsedTime Metric Policy.
     */
    @JvmName("gwrfogurnwvqymqo")
    public suspend fun elapsedTimeMetric(`value`: PipelineElapsedTimeMetricPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elapsedTimeMetric = mapped
    }

    /**
     * @param argument Pipeline ElapsedTime Metric Policy.
     */
    @JvmName("plrfuqfkrhuoipvr")
    public suspend
    fun elapsedTimeMetric(argument: suspend PipelineElapsedTimeMetricPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineElapsedTimeMetricPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.elapsedTimeMetric = mapped
    }

    internal fun build(): PipelinePolicyArgs = PipelinePolicyArgs(
        elapsedTimeMetric = elapsedTimeMetric,
    )
}
