@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PurviewConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Purview configuration.
 * @property purviewResourceId Purview resource id.
 */
public data class PurviewConfigurationArgs(
    public val purviewResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PurviewConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PurviewConfigurationArgs =
        com.pulumi.azurenative.datafactory.inputs.PurviewConfigurationArgs.builder()
            .purviewResourceId(purviewResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PurviewConfigurationArgs].
 */
@PulumiTagMarker
public class PurviewConfigurationArgsBuilder internal constructor() {
    private var purviewResourceId: Output<String>? = null

    /**
     * @param value Purview resource id.
     */
    @JvmName("rpixhlkvmfoyxdkp")
    public suspend fun purviewResourceId(`value`: Output<String>) {
        this.purviewResourceId = value
    }

    /**
     * @param value Purview resource id.
     */
    @JvmName("bweicqydamoyrxuq")
    public suspend fun purviewResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purviewResourceId = mapped
    }

    internal fun build(): PurviewConfigurationArgs = PurviewConfigurationArgs(
        purviewResourceId = purviewResourceId,
    )
}
