@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sftp write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property operationTimeout Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
 * @property type The write setting type.
 * Expected value is 'SftpWriteSettings'.
 * @property useTempFileRename Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
 */
public data class SftpWriteSettingsArgs(
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val operationTimeout: Output<Any>? = null,
    public val type: Output<String>,
    public val useTempFileRename: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SftpWriteSettingsArgs.builder()
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .operationTimeout(operationTimeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useTempFileRename(useTempFileRename?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SftpWriteSettingsArgs].
 */
@PulumiTagMarker
public class SftpWriteSettingsArgsBuilder internal constructor() {
    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var operationTimeout: Output<Any>? = null

    private var type: Output<String>? = null

    private var useTempFileRename: Output<Any>? = null

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("evvgoqiutvdcmimm")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bjyynfuruaqevoqe")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hvnsdwicneljhwsh")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
     */
    @JvmName("hntyifmtvmqvyesg")
    public suspend fun operationTimeout(`value`: Output<Any>) {
        this.operationTimeout = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'SftpWriteSettings'.
     */
    @JvmName("ujkgkttaftvbovge")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("klmsijtsaytwoutw")
    public suspend fun useTempFileRename(`value`: Output<Any>) {
        this.useTempFileRename = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("arcoacjcpgfrwfps")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gtbhockaelreuuxb")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kmwcrwwuvrqackvb")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
     */
    @JvmName("xnieexlwmxbltcvw")
    public suspend fun operationTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationTimeout = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'SftpWriteSettings'.
     */
    @JvmName("luqnrttxjmimwanu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vjixbpbtpxvbdhxr")
    public suspend fun useTempFileRename(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTempFileRename = mapped
    }

    internal fun build(): SftpWriteSettingsArgs = SftpWriteSettingsArgs(
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        operationTimeout = operationTimeout,
        type = type ?: throw PulumiNullFieldException("type"),
        useTempFileRename = useTempFileRename,
    )
}
