@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SkipErrorFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Skip error file.
 * @property dataInconsistency Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property fileMissing Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean).
 */
public data class SkipErrorFileArgs(
    public val dataInconsistency: Output<Any>? = null,
    public val fileMissing: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SkipErrorFileArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SkipErrorFileArgs =
        com.pulumi.azurenative.datafactory.inputs.SkipErrorFileArgs.builder()
            .dataInconsistency(dataInconsistency?.applyValue({ args0 -> args0 }))
            .fileMissing(fileMissing?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkipErrorFileArgs].
 */
@PulumiTagMarker
public class SkipErrorFileArgsBuilder internal constructor() {
    private var dataInconsistency: Output<Any>? = null

    private var fileMissing: Output<Any>? = null

    /**
     * @param value Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("oxegfkbqpqdaggjc")
    public suspend fun dataInconsistency(`value`: Output<Any>) {
        this.dataInconsistency = value
    }

    /**
     * @param value Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ayqsvpkgklrpjcqc")
    public suspend fun fileMissing(`value`: Output<Any>) {
        this.fileMissing = value
    }

    /**
     * @param value Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wqshfwmbgiurbfir")
    public suspend fun dataInconsistency(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataInconsistency = mapped
    }

    /**
     * @param value Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ssteknnttjuoegfl")
    public suspend fun fileMissing(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileMissing = mapped
    }

    internal fun build(): SkipErrorFileArgs = SkipErrorFileArgs(
        dataInconsistency = dataInconsistency,
        fileMissing = fileMissing,
    )
}
