@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SnowflakeExportCopyCommandArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Snowflake export command settings.
 * @property additionalCopyOptions Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE_FORMAT": "MM/DD/YYYY", "TIME_FORMAT": "'HH24:MI:SS.FF'" }
 * @property additionalFormatOptions Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalFormatOptions": { "OVERWRITE": "TRUE", "MAX_FILE_SIZE": "'FALSE'" }
 * @property type The export setting type.
 * Expected value is 'SnowflakeExportCopyCommand'.
 */
public data class SnowflakeExportCopyCommandArgs(
    public val additionalCopyOptions: Output<Map<String, Any>>? = null,
    public val additionalFormatOptions: Output<Map<String, Any>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SnowflakeExportCopyCommandArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SnowflakeExportCopyCommandArgs =
        com.pulumi.azurenative.datafactory.inputs.SnowflakeExportCopyCommandArgs.builder()
            .additionalCopyOptions(
                additionalCopyOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .additionalFormatOptions(
                additionalFormatOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnowflakeExportCopyCommandArgs].
 */
@PulumiTagMarker
public class SnowflakeExportCopyCommandArgsBuilder internal constructor() {
    private var additionalCopyOptions: Output<Map<String, Any>>? = null

    private var additionalFormatOptions: Output<Map<String, Any>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE_FORMAT": "MM/DD/YYYY", "TIME_FORMAT": "'HH24:MI:SS.FF'" }
     */
    @JvmName("jmjmeanmtvugchld")
    public suspend fun additionalCopyOptions(`value`: Output<Map<String, Any>>) {
        this.additionalCopyOptions = value
    }

    /**
     * @param value Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalFormatOptions": { "OVERWRITE": "TRUE", "MAX_FILE_SIZE": "'FALSE'" }
     */
    @JvmName("sgaiiqjnbxjtgrdo")
    public suspend fun additionalFormatOptions(`value`: Output<Map<String, Any>>) {
        this.additionalFormatOptions = value
    }

    /**
     * @param value The export setting type.
     * Expected value is 'SnowflakeExportCopyCommand'.
     */
    @JvmName("ynmmdhcoynovvvnf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE_FORMAT": "MM/DD/YYYY", "TIME_FORMAT": "'HH24:MI:SS.FF'" }
     */
    @JvmName("iljeladatbyivlsj")
    public suspend fun additionalCopyOptions(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCopyOptions = mapped
    }

    /**
     * @param values Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalCopyOptions": { "DATE_FORMAT": "MM/DD/YYYY", "TIME_FORMAT": "'HH24:MI:SS.FF'" }
     */
    @JvmName("rtstrfvaelyrakxs")
    public fun additionalCopyOptions(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalCopyOptions = mapped
    }

    /**
     * @param value Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalFormatOptions": { "OVERWRITE": "TRUE", "MAX_FILE_SIZE": "'FALSE'" }
     */
    @JvmName("hffafidrdduunqph")
    public suspend fun additionalFormatOptions(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalFormatOptions = mapped
    }

    /**
     * @param values Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalFormatOptions": { "OVERWRITE": "TRUE", "MAX_FILE_SIZE": "'FALSE'" }
     */
    @JvmName("ipwcuivcefbykpab")
    public fun additionalFormatOptions(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalFormatOptions = mapped
    }

    /**
     * @param value The export setting type.
     * Expected value is 'SnowflakeExportCopyCommand'.
     */
    @JvmName("asnykqbchrjygbwo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SnowflakeExportCopyCommandArgs = SnowflakeExportCopyCommandArgs(
        additionalCopyOptions = additionalCopyOptions,
        additionalFormatOptions = additionalFormatOptions,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
