@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity SQL source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property isolationLevel Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionOption The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
 * @property partitionSettings The settings that will be leveraged for Sql source partitioning.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlReaderQuery SQL reader query. Type: string (or Expression with resultType string).
 * @property sqlReaderStoredProcedureName Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
 * @property storedProcedureParameters Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
 * @property type Copy source type.
 * Expected value is 'SqlSource'.
 */
public data class SqlSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val isolationLevel: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val partitionOption: Output<Any>? = null,
    public val partitionSettings: Output<SqlPartitionSettingsArgs>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val sqlReaderQuery: Output<Any>? = null,
    public val sqlReaderStoredProcedureName: Output<Any>? = null,
    public val storedProcedureParameters: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .isolationLevel(isolationLevel?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .partitionOption(partitionOption?.applyValue({ args0 -> args0 }))
            .partitionSettings(partitionSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .sqlReaderQuery(sqlReaderQuery?.applyValue({ args0 -> args0 }))
            .sqlReaderStoredProcedureName(sqlReaderStoredProcedureName?.applyValue({ args0 -> args0 }))
            .storedProcedureParameters(storedProcedureParameters?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlSourceArgs].
 */
@PulumiTagMarker
public class SqlSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var isolationLevel: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var partitionOption: Output<Any>? = null

    private var partitionSettings: Output<SqlPartitionSettingsArgs>? = null

    private var queryTimeout: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var sqlReaderQuery: Output<Any>? = null

    private var sqlReaderStoredProcedureName: Output<Any>? = null

    private var storedProcedureParameters: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("rllgnmsfxjgovpsi")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wkwyxanpiokvhedw")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
     */
    @JvmName("lwwoyexyndlxtmlb")
    public suspend fun isolationLevel(`value`: Output<Any>) {
        this.isolationLevel = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("baiddovbusrkwpqa")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
     */
    @JvmName("hbpdqhhemdtpsufa")
    public suspend fun partitionOption(`value`: Output<Any>) {
        this.partitionOption = value
    }

    /**
     * @param value The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("afejtdxcxokidksj")
    public suspend fun partitionSettings(`value`: Output<SqlPartitionSettingsArgs>) {
        this.partitionSettings = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("rqynrwbfovnsaldr")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("xkclosjmrnbsuupe")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("wcxvhuhmulmhdwbh")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value SQL reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("nvnmsygsjridnxwq")
    public suspend fun sqlReaderQuery(`value`: Output<Any>) {
        this.sqlReaderQuery = value
    }

    /**
     * @param value Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
     */
    @JvmName("lfejeorrbqlkdujr")
    public suspend fun sqlReaderStoredProcedureName(`value`: Output<Any>) {
        this.sqlReaderStoredProcedureName = value
    }

    /**
     * @param value Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
     */
    @JvmName("rkykeeplivcowjgq")
    public suspend fun storedProcedureParameters(`value`: Output<Any>) {
        this.storedProcedureParameters = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SqlSource'.
     */
    @JvmName("eqsnqnjlnhpxbuea")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("igdtggwnwjdpqauo")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bthomcwldxvpfrau")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
     */
    @JvmName("ppfvewrftjjeqnfi")
    public suspend fun isolationLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolationLevel = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("flaaloqwyjiylkta")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
     */
    @JvmName("tomayjlfdfpoarim")
    public suspend fun partitionOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionOption = mapped
    }

    /**
     * @param value The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("ljghwsxdlrhrgloe")
    public suspend fun partitionSettings(`value`: SqlPartitionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionSettings = mapped
    }

    /**
     * @param argument The settings that will be leveraged for Sql source partitioning.
     */
    @JvmName("ilwxyluwxxxojpsk")
    public suspend
    fun partitionSettings(argument: suspend SqlPartitionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlPartitionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionSettings = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kupvhdykfrjxhamw")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("yfuetbmresuoujwx")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ahlpmwovrqictfbo")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value SQL reader query. Type: string (or Expression with resultType string).
     */
    @JvmName("ffwwhqoticfqdjfw")
    public suspend fun sqlReaderQuery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlReaderQuery = mapped
    }

    /**
     * @param value Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
     */
    @JvmName("syhihqsckgfoagko")
    public suspend fun sqlReaderStoredProcedureName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlReaderStoredProcedureName = mapped
    }

    /**
     * @param value Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
     */
    @JvmName("whrhxpdutfrbnlva")
    public suspend fun storedProcedureParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedProcedureParameters = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SqlSource'.
     */
    @JvmName("laxpgmkscmvpjcju")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SqlSourceArgs = SqlSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        isolationLevel = isolationLevel,
        maxConcurrentConnections = maxConcurrentConnections,
        partitionOption = partitionOption,
        partitionSettings = partitionSettings,
        queryTimeout = queryTimeout,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        sqlReaderQuery = sqlReaderQuery,
        sqlReaderStoredProcedureName = sqlReaderStoredProcedureName,
        storedProcedureParameters = storedProcedureParameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
