@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SquareLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Square Service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientId The client ID associated with your Square application.
 * @property clientSecret The client secret associated with your Square application.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The URL of the Square instance. (i.e. mystore.mysquare.com)
 * @property parameters Parameters for linked service.
 * @property redirectUri The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500)
 * @property type Type of linked service.
 * Expected value is 'Square'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class SquareLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionProperties: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val redirectUri: Output<Any>? = null,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
    public val useHostVerification: Output<Any>? = null,
    public val usePeerVerification: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SquareLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SquareLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SquareLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionProperties(connectionProperties?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .redirectUri(redirectUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 }))
            .useHostVerification(useHostVerification?.applyValue({ args0 -> args0 }))
            .usePeerVerification(usePeerVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SquareLinkedServiceArgs].
 */
@PulumiTagMarker
public class SquareLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionProperties: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var redirectUri: Output<Any>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    private var useHostVerification: Output<Any>? = null

    private var usePeerVerification: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("yeqnisinhggvavvq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("fsuiahuwpnclrlvd")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hdcrooagqqfbufmb")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The client ID associated with your Square application.
     */
    @JvmName("cvidetobhilfqpop")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret associated with your Square application.
     */
    @JvmName("ikxxjdcwsfgmwyor")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("pdqvlxbnrlklpcnv")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("ccsoiofqhdhqnasm")
    public suspend fun connectionProperties(`value`: Output<Any>) {
        this.connectionProperties = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ssqbjddtigwawuts")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vyprekdecbwecloh")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The URL of the Square instance. (i.e. mystore.mysquare.com)
     */
    @JvmName("fnxqiwskhufgdrre")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("jnejpuibrteflohq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500)
     */
    @JvmName("nhttspcxajyyngyt")
    public suspend fun redirectUri(`value`: Output<Any>) {
        this.redirectUri = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Square'.
     */
    @JvmName("fexjbuqqewvwuiml")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("krigiyufkoxrnckj")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("dsdatnhdxwpwelau")
    public suspend fun useHostVerification(`value`: Output<Any>) {
        this.useHostVerification = value
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("wirqhmsdtsrafswb")
    public suspend fun usePeerVerification(`value`: Output<Any>) {
        this.usePeerVerification = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("optqergijvowukhq")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("biavtlrhjdvakfgo")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The client ID associated with your Square application.
     */
    @JvmName("wiesddtafnllambf")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret associated with your Square application.
     */
    @JvmName("jhswsdkonnixqvkt")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret associated with your Square application.
     */
    @JvmName("egxhrfpkasuudtjc")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret associated with your Square application.
     */
    @JvmName("pmvvwboohyixlcud")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("qyjbvghytswfoubl")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("owohxdccmexupggl")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("tsjwkkvsmgeraead")
    public suspend fun connectionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wgcaemwjbtmvpliu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("igbqdlulxmbcwgxm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The URL of the Square instance. (i.e. mystore.mysquare.com)
     */
    @JvmName("sceilefvjelbgkuu")
    public suspend fun host(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("swtfxvfyffaumxiw")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ewtprrpnwqctqpru")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("bvshxkkeygwmjnsf")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500)
     */
    @JvmName("blkpxxjgweaqxsvn")
    public suspend fun redirectUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUri = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Square'.
     */
    @JvmName("xudrcoycxvhlejju")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("jgpkflhowtfjofgh")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("eptdighuwfbhdmql")
    public suspend fun useHostVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHostVerification = mapped
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("ojurfogneshtvbhe")
    public suspend fun usePeerVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePeerVerification = mapped
    }

    internal fun build(): SquareLinkedServiceArgs = SquareLinkedServiceArgs(
        annotations = annotations,
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        connectionProperties = connectionProperties,
        description = description,
        encryptedCredential = encryptedCredential,
        host = host,
        parameters = parameters,
        redirectUri = redirectUri,
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
        useHostVerification = useHostVerification,
        usePeerVerification = usePeerVerification,
    )
}
