@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobDefinitionActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.ConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Execute spark job activity.
 * @property arguments User specified arguments to SynapseSparkJobDefinitionActivity.
 * @property className The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string).
 * @property conf Spark configuration properties, which will override the 'conf' of the spark job definition you provide.
 * @property configurationType The type of the spark config.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property driverSize Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
 * @property executorSize Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
 * @property file The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string).
 * @property files (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
 * @property filesV2 Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property numExecutors Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer).
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property pythonCodeReference Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
 * @property scanFolder Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
 * @property sparkConfig Spark configuration property.
 * @property sparkJob Synapse spark job reference.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property targetBigDataPool The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide.
 * @property targetSparkConfiguration The spark configuration of the spark job.
 * @property type Type of activity.
 * Expected value is 'SparkJob'.
 * @property userProperties Activity user properties.
 */
public data class SynapseSparkJobDefinitionActivityArgs(
    public val arguments: Output<List<Any>>? = null,
    public val className: Output<Any>? = null,
    public val conf: Output<Any>? = null,
    public val configurationType: Output<Either<String, ConfigurationType>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val driverSize: Output<Any>? = null,
    public val executorSize: Output<Any>? = null,
    public val `file`: Output<Any>? = null,
    public val files: Output<List<Any>>? = null,
    public val filesV2: Output<List<Any>>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val numExecutors: Output<Any>? = null,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val pythonCodeReference: Output<List<Any>>? = null,
    public val scanFolder: Output<Any>? = null,
    public val sparkConfig: Output<Map<String, Any>>? = null,
    public val sparkJob: Output<SynapseSparkJobReferenceArgs>,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val targetBigDataPool: Output<BigDataPoolParametrizationReferenceArgs>? = null,
    public val targetSparkConfiguration: Output<SparkConfigurationParametrizationReferenceArgs>? =
        null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobDefinitionActivityArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobDefinitionActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.SynapseSparkJobDefinitionActivityArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .className(className?.applyValue({ args0 -> args0 }))
            .conf(conf?.applyValue({ args0 -> args0 }))
            .configurationType(
                configurationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .driverSize(driverSize?.applyValue({ args0 -> args0 }))
            .executorSize(executorSize?.applyValue({ args0 -> args0 }))
            .`file`(`file`?.applyValue({ args0 -> args0 }))
            .files(files?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filesV2(filesV2?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .numExecutors(numExecutors?.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pythonCodeReference(pythonCodeReference?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .scanFolder(scanFolder?.applyValue({ args0 -> args0 }))
            .sparkConfig(
                sparkConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sparkJob(sparkJob.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetBigDataPool(targetBigDataPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetSparkConfiguration(
                targetSparkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SynapseSparkJobDefinitionActivityArgs].
 */
@PulumiTagMarker
public class SynapseSparkJobDefinitionActivityArgsBuilder internal constructor() {
    private var arguments: Output<List<Any>>? = null

    private var className: Output<Any>? = null

    private var conf: Output<Any>? = null

    private var configurationType: Output<Either<String, ConfigurationType>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var driverSize: Output<Any>? = null

    private var executorSize: Output<Any>? = null

    private var `file`: Output<Any>? = null

    private var files: Output<List<Any>>? = null

    private var filesV2: Output<List<Any>>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var numExecutors: Output<Any>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var pythonCodeReference: Output<List<Any>>? = null

    private var scanFolder: Output<Any>? = null

    private var sparkConfig: Output<Map<String, Any>>? = null

    private var sparkJob: Output<SynapseSparkJobReferenceArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var targetBigDataPool: Output<BigDataPoolParametrizationReferenceArgs>? = null

    private var targetSparkConfiguration: Output<SparkConfigurationParametrizationReferenceArgs>? =
        null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value User specified arguments to SynapseSparkJobDefinitionActivity.
     */
    @JvmName("nxbnvaxrbnovhbsn")
    public suspend fun arguments(`value`: Output<List<Any>>) {
        this.arguments = value
    }

    @JvmName("eucboptcjxdsruhn")
    public suspend fun arguments(vararg values: Output<Any>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values User specified arguments to SynapseSparkJobDefinitionActivity.
     */
    @JvmName("nwxgdmhleoccedec")
    public suspend fun arguments(values: List<Output<Any>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("tkvnsmnpdpyhflgv")
    public suspend fun className(`value`: Output<Any>) {
        this.className = value
    }

    /**
     * @param value Spark configuration properties, which will override the 'conf' of the spark job definition you provide.
     */
    @JvmName("desoucrajtutuyvm")
    public suspend fun conf(`value`: Output<Any>) {
        this.conf = value
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("rlqxewfnfpxuptjt")
    public suspend fun configurationType(`value`: Output<Either<String, ConfigurationType>>) {
        this.configurationType = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("pelwidgfoxdoyvri")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("gyddpygmmitmsdbx")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("htmqpdadytkelqpq")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("syalwtteroftkwen")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("ijvaaibdmeriuvmb")
    public suspend fun driverSize(`value`: Output<Any>) {
        this.driverSize = value
    }

    /**
     * @param value Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("ffmxircfxpgsuhmo")
    public suspend fun executorSize(`value`: Output<Any>) {
        this.executorSize = value
    }

    /**
     * @param value The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("jrxprrgvapdayedt")
    public suspend fun `file`(`value`: Output<Any>) {
        this.`file` = value
    }

    /**
     * @param value (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     */
    @JvmName("ifxefywwhbhtndxn")
    public suspend fun files(`value`: Output<List<Any>>) {
        this.files = value
    }

    @JvmName("nuoifaqqdwbtidyy")
    public suspend fun files(vararg values: Output<Any>) {
        this.files = Output.all(values.asList())
    }

    /**
     * @param values (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     */
    @JvmName("deflduoxukwbptqp")
    public suspend fun files(values: List<Output<Any>>) {
        this.files = Output.all(values)
    }

    /**
     * @param value Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
     */
    @JvmName("cjmafcbathvdukph")
    public suspend fun filesV2(`value`: Output<List<Any>>) {
        this.filesV2 = value
    }

    @JvmName("qgbkcquwgxejfycg")
    public suspend fun filesV2(vararg values: Output<Any>) {
        this.filesV2 = Output.all(values.asList())
    }

    /**
     * @param values Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
     */
    @JvmName("jcprayiaeyivqmxc")
    public suspend fun filesV2(values: List<Output<Any>>) {
        this.filesV2 = Output.all(values)
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("gfgecmlnhwjfbvry")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("ybldqbhqnjhsombs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ddqqenlmjvnmqcod")
    public suspend fun numExecutors(`value`: Output<Any>) {
        this.numExecutors = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("fbasnuygecsgqcls")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("psijkdestyyktcwb")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
     */
    @JvmName("oyeehjeacisiutan")
    public suspend fun pythonCodeReference(`value`: Output<List<Any>>) {
        this.pythonCodeReference = value
    }

    @JvmName("cgagpygmgkxdqkkw")
    public suspend fun pythonCodeReference(vararg values: Output<Any>) {
        this.pythonCodeReference = Output.all(values.asList())
    }

    /**
     * @param values Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
     */
    @JvmName("tbwutdnevvxkwsux")
    public suspend fun pythonCodeReference(values: List<Output<Any>>) {
        this.pythonCodeReference = Output.all(values)
    }

    /**
     * @param value Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jvekrillniwsjxtb")
    public suspend fun scanFolder(`value`: Output<Any>) {
        this.scanFolder = value
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("gjpvpvfygjdajonx")
    public suspend fun sparkConfig(`value`: Output<Map<String, Any>>) {
        this.sparkConfig = value
    }

    /**
     * @param value Synapse spark job reference.
     */
    @JvmName("ttmqgfdasgmuxdeo")
    public suspend fun sparkJob(`value`: Output<SynapseSparkJobReferenceArgs>) {
        this.sparkJob = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ybpupokmylfrribp")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     */
    @JvmName("uwqxabwrxjbbfanm")
    public suspend fun targetBigDataPool(`value`: Output<BigDataPoolParametrizationReferenceArgs>) {
        this.targetBigDataPool = value
    }

    /**
     * @param value The spark configuration of the spark job.
     */
    @JvmName("cfhtoskpgkcmmswy")
    public suspend
    fun targetSparkConfiguration(`value`: Output<SparkConfigurationParametrizationReferenceArgs>) {
        this.targetSparkConfiguration = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'SparkJob'.
     */
    @JvmName("rfbheojrgihhcawo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("flckxjgrwdaknxoa")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("uvjipsatfovlxtjs")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("pfderserkkrlncrj")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value User specified arguments to SynapseSparkJobDefinitionActivity.
     */
    @JvmName("iortvtjqxhaaysxc")
    public suspend fun arguments(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values User specified arguments to SynapseSparkJobDefinitionActivity.
     */
    @JvmName("etjyvjxheosufhyt")
    public suspend fun arguments(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("guongnehhypatdis")
    public suspend fun className(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.className = mapped
    }

    /**
     * @param value Spark configuration properties, which will override the 'conf' of the spark job definition you provide.
     */
    @JvmName("saknwrvhtydojgnw")
    public suspend fun conf(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conf = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("raurwbmsfgtyquvo")
    public suspend fun configurationType(`value`: Either<String, ConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("umpppcphyeggylru")
    public fun configurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config.
     */
    @JvmName("ginldstoiieuvkhi")
    public fun configurationType(`value`: ConfigurationType) {
        val toBeMapped = Either.ofRight<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("ypqdglgpawsgqtee")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("qfbaswvdmjoiyhlq")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("fhiukmjiqlakuaxd")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("kxrkiavqusqovmeh")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("dilxqodtdiiedjcn")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("roqqimtphcmehikc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("lmsxjrbsitobfhus")
    public suspend fun driverSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driverSize = mapped
    }

    /**
     * @param value Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("vffrvousokpkxwvf")
    public suspend fun executorSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executorSize = mapped
    }

    /**
     * @param value The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JvmName("fkmgvrbhadstypjg")
    public suspend fun `file`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param value (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     */
    @JvmName("imsuggifmipdwsnh")
    public suspend fun files(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param values (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     */
    @JvmName("twqsifrihnxkfqsf")
    public suspend fun files(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param value Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
     */
    @JvmName("ckvweelxvueuvoni")
    public suspend fun filesV2(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filesV2 = mapped
    }

    /**
     * @param values Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
     */
    @JvmName("moidwbucpdmyckqx")
    public suspend fun filesV2(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filesV2 = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("efuewsiuixsicmvh")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("egdeptsbhpaxcgdp")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vcklyvnpgqhklhlq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cvxmwewfotjthaap")
    public suspend fun numExecutors(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numExecutors = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("gyrmehkwoytmjfll")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("nabohjxmbuayfbek")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("xmbmovkglfaufola")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("eflshdunnaljxioc")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("suejrdmvpfmjmrea")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
     */
    @JvmName("qyxmjfyxdslbysbo")
    public suspend fun pythonCodeReference(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pythonCodeReference = mapped
    }

    /**
     * @param values Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
     */
    @JvmName("mkjmvaiuvtcnfsvp")
    public suspend fun pythonCodeReference(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pythonCodeReference = mapped
    }

    /**
     * @param value Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("awtkpcgcafmgkrfg")
    public suspend fun scanFolder(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanFolder = mapped
    }

    /**
     * @param value Spark configuration property.
     */
    @JvmName("fsqurjxwtesaxjrh")
    public suspend fun sparkConfig(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param values Spark configuration property.
     */
    @JvmName("yayphljpxmcvaruy")
    public fun sparkConfig(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkConfig = mapped
    }

    /**
     * @param value Synapse spark job reference.
     */
    @JvmName("cxbpqosdlyxvmlhh")
    public suspend fun sparkJob(`value`: SynapseSparkJobReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkJob = mapped
    }

    /**
     * @param argument Synapse spark job reference.
     */
    @JvmName("nfvrgefwxnxgepsc")
    public suspend fun sparkJob(argument: suspend SynapseSparkJobReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SynapseSparkJobReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sparkJob = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("tevhyiuujdxgrvfp")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("oafxuydwuwkqsvps")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("kjrohmngpsrsyney")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     */
    @JvmName("noskopuiqahqovaw")
    public suspend fun targetBigDataPool(`value`: BigDataPoolParametrizationReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBigDataPool = mapped
    }

    /**
     * @param argument The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     */
    @JvmName("mvdffvdrgkhrrtkm")
    public suspend
    fun targetBigDataPool(argument: suspend BigDataPoolParametrizationReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = BigDataPoolParametrizationReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetBigDataPool = mapped
    }

    /**
     * @param value The spark configuration of the spark job.
     */
    @JvmName("emjtekecoudspsbr")
    public suspend
    fun targetSparkConfiguration(`value`: SparkConfigurationParametrizationReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSparkConfiguration = mapped
    }

    /**
     * @param argument The spark configuration of the spark job.
     */
    @JvmName("dtpngswghcdgqouc")
    public suspend
    fun targetSparkConfiguration(argument: suspend SparkConfigurationParametrizationReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SparkConfigurationParametrizationReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetSparkConfiguration = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'SparkJob'.
     */
    @JvmName("ksoeyoupypxuovdg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("weswblvywgpkkvqe")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("nkvnflscakagjtkn")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("pwyekcdblixsfqof")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("romqfnhhxnfbjait")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("wrrumuefpggvaxsl")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): SynapseSparkJobDefinitionActivityArgs =
        SynapseSparkJobDefinitionActivityArgs(
            arguments = arguments,
            className = className,
            conf = conf,
            configurationType = configurationType,
            dependsOn = dependsOn,
            description = description,
            driverSize = driverSize,
            executorSize = executorSize,
            `file` = `file`,
            files = files,
            filesV2 = filesV2,
            linkedServiceName = linkedServiceName,
            name = name ?: throw PulumiNullFieldException("name"),
            numExecutors = numExecutors,
            onInactiveMarkAs = onInactiveMarkAs,
            policy = policy,
            pythonCodeReference = pythonCodeReference,
            scanFolder = scanFolder,
            sparkConfig = sparkConfig,
            sparkJob = sparkJob ?: throw PulumiNullFieldException("sparkJob"),
            state = state,
            targetBigDataPool = targetBigDataPool,
            targetSparkConfiguration = targetSparkConfiguration,
            type = type ?: throw PulumiNullFieldException("type"),
            userProperties = userProperties,
        )
}
