@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TriggerReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.TriggerReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger reference type.
 * @property referenceName Reference trigger name.
 * @property type Trigger reference type.
 */
public data class TriggerReferenceArgs(
    public val referenceName: Output<String>,
    public val type: Output<Either<String, TriggerReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TriggerReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TriggerReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.TriggerReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TriggerReferenceArgs].
 */
@PulumiTagMarker
public class TriggerReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, TriggerReferenceType>>? = null

    /**
     * @param value Reference trigger name.
     */
    @JvmName("epeyoiptfhwosenr")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Trigger reference type.
     */
    @JvmName("wlcoxwnvwhcijhue")
    public suspend fun type(`value`: Output<Either<String, TriggerReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference trigger name.
     */
    @JvmName("hrssqvtjljyjcmiy")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Trigger reference type.
     */
    @JvmName("jbqjomaisxcdqfsj")
    public suspend fun type(`value`: Either<String, TriggerReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Trigger reference type.
     */
    @JvmName("rviaejoeharrtxef")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Trigger reference type.
     */
    @JvmName("hypxalcdtcvlmgee")
    public fun type(`value`: TriggerReferenceType) {
        val toBeMapped = Either.ofRight<String, TriggerReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TriggerReferenceArgs = TriggerReferenceArgs(
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
