@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.WebActivityMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Web activity.
 * @property authentication Authentication method used for calling the endpoint.
 * @property body Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property datasets List of datasets passed to web endpoint.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property disableCertValidation When set to true, Certificate validation will be disabled.
 * @property headers Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property linkedServices List of linked services passed to web endpoint.
 * @property method Rest API method for target endpoint.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'WebActivity'.
 * @property url Web activity target endpoint and path. Type: string (or Expression with resultType string).
 * @property userProperties Activity user properties.
 */
public data class WebActivityArgs(
    public val authentication: Output<WebActivityAuthenticationArgs>? = null,
    public val body: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val datasets: Output<List<DatasetReferenceArgs>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val disableCertValidation: Output<Boolean>? = null,
    public val headers: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val method: Output<Either<String, WebActivityMethod>>,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.WebActivityArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datasets(
                datasets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .disableCertValidation(disableCertValidation?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServices(
                linkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .method(
                method.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebActivityArgs].
 */
@PulumiTagMarker
public class WebActivityArgsBuilder internal constructor() {
    private var authentication: Output<WebActivityAuthenticationArgs>? = null

    private var body: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var datasets: Output<List<DatasetReferenceArgs>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var disableCertValidation: Output<Boolean>? = null

    private var headers: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var method: Output<Either<String, WebActivityMethod>>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Authentication method used for calling the endpoint.
     */
    @JvmName("hjmsxvjmxhmsjkek")
    public suspend fun authentication(`value`: Output<WebActivityAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
     */
    @JvmName("uaiovypbeobehror")
    public suspend fun body(`value`: Output<Any>) {
        this.body = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("arclaavkkrgnioaf")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value List of datasets passed to web endpoint.
     */
    @JvmName("vbxtjdhnqqfbyfdk")
    public suspend fun datasets(`value`: Output<List<DatasetReferenceArgs>>) {
        this.datasets = value
    }

    @JvmName("djghoetofbhfwuag")
    public suspend fun datasets(vararg values: Output<DatasetReferenceArgs>) {
        this.datasets = Output.all(values.asList())
    }

    /**
     * @param values List of datasets passed to web endpoint.
     */
    @JvmName("upipyqudhypxmiyf")
    public suspend fun datasets(values: List<Output<DatasetReferenceArgs>>) {
        this.datasets = Output.all(values)
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("lebpegwxrkdnalli")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("rehmtktdsmpckrjy")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("evklbpjauicannrf")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("emaecwxeooeyhlru")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value When set to true, Certificate validation will be disabled.
     */
    @JvmName("ciuuiepnyxepjwix")
    public suspend fun disableCertValidation(`value`: Output<Boolean>) {
        this.disableCertValidation = value
    }

    /**
     * @param value Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JvmName("cqxkwlnhhywwshll")
    public suspend fun headers(`value`: Output<Any>) {
        this.headers = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("wcitkkanimgniwxd")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value List of linked services passed to web endpoint.
     */
    @JvmName("ajnhcctgnhfcppme")
    public suspend fun linkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.linkedServices = value
    }

    @JvmName("txmxwcxxdepkfnim")
    public suspend fun linkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.linkedServices = Output.all(values.asList())
    }

    /**
     * @param values List of linked services passed to web endpoint.
     */
    @JvmName("otrindgydoutfvhu")
    public suspend fun linkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.linkedServices = Output.all(values)
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("awhwjgapiwxybvsx")
    public suspend fun method(`value`: Output<Either<String, WebActivityMethod>>) {
        this.method = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("axvemvvmroecrdpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("xplbdlajfokwrcwp")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("mkxmeqqfhtxcgaii")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("mrtqxlkveorlmmye")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'WebActivity'.
     */
    @JvmName("wfhqefivnkktlqfa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Web activity target endpoint and path. Type: string (or Expression with resultType string).
     */
    @JvmName("afpyunbittnfxpqh")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("cyepoeqiiifmpxif")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("guybloqdfktwhunr")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("pymsgxpoecgpcork")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Authentication method used for calling the endpoint.
     */
    @JvmName("tnogjyatecrfjdea")
    public suspend fun authentication(`value`: WebActivityAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Authentication method used for calling the endpoint.
     */
    @JvmName("fsurrojbngxpowin")
    public suspend
    fun authentication(argument: suspend WebActivityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = WebActivityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
     */
    @JvmName("jiquqmgpacknqvyf")
    public suspend fun body(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xjxaqpkbssunvjgf")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("dmlprdidovwxvdms")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value List of datasets passed to web endpoint.
     */
    @JvmName("orxkerematyklvak")
    public suspend fun datasets(`value`: List<DatasetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("nfpfvvmlghccwgsc")
    public suspend fun datasets(argument: List<suspend DatasetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("xsknvnunohdkwrhf")
    public suspend fun datasets(vararg argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("yyvllhnyrdtfqwjv")
    public suspend fun datasets(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatasetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param values List of datasets passed to web endpoint.
     */
    @JvmName("xfoluvbyxkiqybxg")
    public suspend fun datasets(vararg values: DatasetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("jbmtpljioemigocj")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("vrwloprhbcugwxdh")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("tptlmggqigfyqhiu")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("wrljwukvuybtraep")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("mikvgxeeyxaaguto")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("bmcyrdnopybvquuy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value When set to true, Certificate validation will be disabled.
     */
    @JvmName("adrqvlmyaokdehou")
    public suspend fun disableCertValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableCertValidation = mapped
    }

    /**
     * @param value Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JvmName("ivoklhhcqiabiyrp")
    public suspend fun headers(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("qsljgjkuykduwrls")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("aegkodpqpxbqxyaq")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value List of linked services passed to web endpoint.
     */
    @JvmName("fwypouioulforxrd")
    public suspend fun linkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("cbwpmhunjrlcgeqe")
    public suspend
    fun linkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("lkmjpgxrgldibugg")
    public suspend fun linkedServices(
        vararg
        argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("dsosrtsmwghvolly")
    public suspend
    fun linkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param values List of linked services passed to web endpoint.
     */
    @JvmName("tvasejhyvjrxxnwr")
    public suspend fun linkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("pqjjcahxuxmymaxj")
    public suspend fun method(`value`: Either<String, WebActivityMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("smurmmmcmqmrvsei")
    public fun method(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebActivityMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("xhyptymvqlveuhxi")
    public fun method(`value`: WebActivityMethod) {
        val toBeMapped = Either.ofRight<String, WebActivityMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("blvjhxvrhjrppauk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("tmmoehgxosceenro")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("wsxxfrayomthegne")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("bkqweffnmcmcnmbt")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("mpfcjlhuhtmgbyvs")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("tfybjligismxpkni")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("jiodsaokgqawtynj")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("wjcenoecwghgueog")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("gsybvilgemroatrw")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'WebActivity'.
     */
    @JvmName("bqmugqxqqeepetac")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Web activity target endpoint and path. Type: string (or Expression with resultType string).
     */
    @JvmName("dxjtwlsjtftsjrda")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("dnpaloejlsokgpvr")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("lfkafdaatqcuaouh")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("kbcdutlkgkvxamvm")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("mlgouriuvaelyqui")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("hwxauaxriknthoec")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): WebActivityArgs = WebActivityArgs(
        authentication = authentication,
        body = body,
        connectVia = connectVia,
        datasets = datasets,
        dependsOn = dependsOn,
        description = description,
        disableCertValidation = disableCertValidation,
        headers = headers,
        linkedServiceName = linkedServiceName,
        linkedServices = linkedServices,
        method = method ?: throw PulumiNullFieldException("method"),
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userProperties = userProperties,
    )
}
