@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Amazon Marketplace Web Service linked service.
 * @property accessKeyId The access key id used to access data.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
 * @property marketplaceID The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
 * @property mwsAuthToken The Amazon MWS authentication token.
 * @property parameters Parameters for linked service.
 * @property secretKey The secret key used to access data.
 * @property sellerID The Amazon seller ID.
 * @property type Type of linked service.
 * Expected value is 'AmazonMWS'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class AmazonMWSLinkedServiceResponse(
    public val accessKeyId: Any,
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val endpoint: Any,
    public val marketplaceID: Any,
    public val mwsAuthToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val secretKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val sellerID: Any,
    public val type: String,
    public val useEncryptedEndpoints: Any? = null,
    public val useHostVerification: Any? = null,
    public val usePeerVerification: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AmazonMWSLinkedServiceResponse):
            AmazonMWSLinkedServiceResponse = AmazonMWSLinkedServiceResponse(
            accessKeyId = javaType.accessKeyId(),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            marketplaceID = javaType.marketplaceID(),
            mwsAuthToken = javaType.mwsAuthToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            secretKey = javaType.secretKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            sellerID = javaType.sellerID(),
            type = javaType.type(),
            useEncryptedEndpoints = javaType.useEncryptedEndpoints().map({ args0 -> args0 }).orElse(null),
            useHostVerification = javaType.useHostVerification().map({ args0 -> args0 }).orElse(null),
            usePeerVerification = javaType.usePeerVerification().map({ args0 -> args0 }).orElse(null),
        )
    }
}
