@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property bucketName The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
 * @property compression The data compression method used for the Amazon S3 object.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property format The format of files.
 * @property key The key of the Amazon S3 object. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property modifiedDatetimeEnd The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property prefix The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'AmazonS3Object'.
 * @property version The version for the S3 object. Type: string (or Expression with resultType string).
 */
public data class AmazonS3DatasetResponse(
    public val annotations: List<Any>? = null,
    public val bucketName: Any,
    public val compression: DatasetCompressionResponse? = null,
    public val description: String? = null,
    public val folder: DatasetResponseFolder? = null,
    public val format: Any? = null,
    public val key: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val modifiedDatetimeEnd: Any? = null,
    public val modifiedDatetimeStart: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val prefix: Any? = null,
    public val schema: Any? = null,
    public val structure: Any? = null,
    public val type: String,
    public val version: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AmazonS3DatasetResponse):
            AmazonS3DatasetResponse = AmazonS3DatasetResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            bucketName = javaType.bucketName(),
            compression = javaType.compression().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetCompressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            modifiedDatetimeEnd = javaType.modifiedDatetimeEnd().map({ args0 -> args0 }).orElse(null),
            modifiedDatetimeStart = javaType.modifiedDatetimeStart().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
