@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for Amazon S3.
 * @property accessKeyId The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property secretAccessKey The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
 * @property serviceUrl This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
 * @property sessionToken The session token for the S3 temporary security credential.
 * @property type Type of linked service.
 * Expected value is 'AmazonS3'.
 */
public data class AmazonS3LinkedServiceResponse(
    public val accessKeyId: Any? = null,
    public val annotations: List<Any>? = null,
    public val authenticationType: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val secretAccessKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val serviceUrl: Any? = null,
    public val sessionToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AmazonS3LinkedServiceResponse):
            AmazonS3LinkedServiceResponse = AmazonS3LinkedServiceResponse(
            accessKeyId = javaType.accessKeyId().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            secretAccessKey = javaType.secretAccessKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            serviceUrl = javaType.serviceUrl().map({ args0 -> args0 }).orElse(null),
            sessionToken = javaType.sessionToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
