@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The location of amazon S3 dataset.
 * @property bucketName Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AmazonS3Location'.
 * @property version Specify the version of amazon S3. Type: string (or Expression with resultType string).
 */
public data class AmazonS3LocationResponse(
    public val bucketName: Any? = null,
    public val fileName: Any? = null,
    public val folderPath: Any? = null,
    public val type: String,
    public val version: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AmazonS3LocationResponse):
            AmazonS3LocationResponse = AmazonS3LocationResponse(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
