@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Data Lake Analytics linked service.
 * @property accountName The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property dataLakeAnalyticsUri Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property resourceGroupName Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The Key of the application used to authenticate against the Azure Data Lake Analytics account.
 * @property subscriptionId Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureDataLakeAnalytics'.
 */
public data class AzureDataLakeAnalyticsLinkedServiceResponse(
    public val accountName: Any,
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val dataLakeAnalyticsUri: Any? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val resourceGroupName: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val subscriptionId: Any? = null,
    public val tenant: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDataLakeAnalyticsLinkedServiceResponse):
            AzureDataLakeAnalyticsLinkedServiceResponse = AzureDataLakeAnalyticsLinkedServiceResponse(
            accountName = javaType.accountName(),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataLakeAnalyticsUri = javaType.dataLakeAnalyticsUri().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenant = javaType.tenant(),
            type = javaType.type(),
        )
    }
}
