@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Azure data lake store write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property expiryDateTime Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'AzureDataLakeStoreWriteSettings'.
 */
public data class AzureDataLakeStoreWriteSettingsResponse(
    public val copyBehavior: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val expiryDateTime: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDataLakeStoreWriteSettingsResponse):
            AzureDataLakeStoreWriteSettingsResponse = AzureDataLakeStoreWriteSettingsResponse(
            copyBehavior = javaType.copyBehavior().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            expiryDateTime = javaType.expiryDateTime().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
