@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Function linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property functionAppUrl The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net.
 * @property functionKey Function or Host key for Azure Function App.
 * @property parameters Parameters for linked service.
 * @property resourceId Allowed token audiences for azure function.
 * @property type Type of linked service.
 * Expected value is 'AzureFunction'.
 */
public data class AzureFunctionLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authentication: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val functionAppUrl: Any,
    public val functionKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val resourceId: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureFunctionLinkedServiceResponse):
            AzureFunctionLinkedServiceResponse = AzureFunctionLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            functionAppUrl = javaType.functionAppUrl(),
            functionKey = javaType.functionKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
