@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Big data pool reference type.
 * @property referenceName Reference big data pool name. Type: string (or Expression with resultType string).
 * @property type Big data pool reference type.
 */
public data class BigDataPoolParametrizationReferenceResponse(
    public val referenceName: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.BigDataPoolParametrizationReferenceResponse):
            BigDataPoolParametrizationReferenceResponse = BigDataPoolParametrizationReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
