@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The connection state of a managed private endpoint
 * @property actionsRequired The actions required on the managed private endpoint
 * @property description The managed private endpoint description
 * @property status The approval status
 */
public data class ConnectionStatePropertiesResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ConnectionStatePropertiesResponse):
            ConnectionStatePropertiesResponse = ConnectionStatePropertiesResponse(
            actionsRequired = javaType.actionsRequired(),
            description = javaType.description(),
            status = javaType.status(),
        )
    }
}
