@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Settings for copy activity log.
 * @property enableReliableLogging Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
 * @property logLevel Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
 */
public data class CopyActivityLogSettingsResponse(
    public val enableReliableLogging: Any? = null,
    public val logLevel: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CopyActivityLogSettingsResponse):
            CopyActivityLogSettingsResponse = CopyActivityLogSettingsResponse(
            enableReliableLogging = javaType.enableReliableLogging().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
