@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Copy activity.
 * @property dataIntegrationUnits Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property enableSkipIncompatibleRow Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property enableStaging Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property inputs List of inputs for the activity.
 * @property linkedServiceName Linked service reference.
 * @property logSettings Log settings customer needs provide when enabling log.
 * @property logStorageSettings (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property outputs List of outputs for the activity.
 * @property parallelCopies Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property policy Activity policy.
 * @property preserve Preserve rules.
 * @property preserveRules Preserve Rules.
 * @property redirectIncompatibleRowSettings Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
 * @property sink Copy activity sink.
 * @property skipErrorFile Specify the fault tolerance for data consistency.
 * @property source Copy activity source.
 * @property stagingSettings Specifies interim staging settings when EnableStaging is true.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property translator Copy activity translator. If not specified, tabular translator is used.
 * @property type Type of activity.
 * Expected value is 'Copy'.
 * @property userProperties Activity user properties.
 * @property validateDataConsistency Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
 */
public data class CopyActivityResponse(
    public val dataIntegrationUnits: Any? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val enableSkipIncompatibleRow: Any? = null,
    public val enableStaging: Any? = null,
    public val inputs: List<DatasetReferenceResponse>? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val logSettings: LogSettingsResponse? = null,
    public val logStorageSettings: LogStorageSettingsResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val outputs: List<DatasetReferenceResponse>? = null,
    public val parallelCopies: Any? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val preserve: List<Any>? = null,
    public val preserveRules: List<Any>? = null,
    public val redirectIncompatibleRowSettings: RedirectIncompatibleRowSettingsResponse? = null,
    public val sink: Any,
    public val skipErrorFile: SkipErrorFileResponse? = null,
    public val source: Any,
    public val stagingSettings: StagingSettingsResponse? = null,
    public val state: String? = null,
    public val translator: Any? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
    public val validateDataConsistency: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CopyActivityResponse):
            CopyActivityResponse = CopyActivityResponse(
            dataIntegrationUnits = javaType.dataIntegrationUnits().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enableSkipIncompatibleRow = javaType.enableSkipIncompatibleRow().map({ args0 ->
                args0
            }).orElse(null),
            enableStaging = javaType.enableStaging().map({ args0 -> args0 }).orElse(null),
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logSettings = javaType.logSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LogSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logStorageSettings = javaType.logStorageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LogStorageSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            parallelCopies = javaType.parallelCopies().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preserve = javaType.preserve().map({ args0 -> args0 }),
            preserveRules = javaType.preserveRules().map({ args0 -> args0 }),
            redirectIncompatibleRowSettings = javaType.redirectIncompatibleRowSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.RedirectIncompatibleRowSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sink = javaType.sink(),
            skipErrorFile = javaType.skipErrorFile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SkipErrorFileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            source = javaType.source(),
            stagingSettings = javaType.stagingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.StagingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            translator = javaType.translator().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            validateDataConsistency = javaType.validateDataConsistency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
