@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Reference objects for custom activity
 * @property datasets Dataset references.
 * @property linkedServices Linked service references.
 */
public data class CustomActivityReferenceObjectResponse(
    public val datasets: List<DatasetReferenceResponse>? = null,
    public val linkedServices: List<LinkedServiceReferenceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CustomActivityReferenceObjectResponse):
            CustomActivityReferenceObjectResponse = CustomActivityReferenceObjectResponse(
            datasets = javaType.datasets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            linkedServices = javaType.linkedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
