@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Data flow reference type.
 * @property datasetParameters Reference data flow parameters from dataset.
 * @property parameters Data flow parameters
 * @property referenceName Reference data flow name.
 * @property type Data flow reference type.
 */
public data class DataFlowReferenceResponse(
    public val datasetParameters: Any? = null,
    public val parameters: Map<String, Any>? = null,
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DataFlowReferenceResponse):
            DataFlowReferenceResponse = DataFlowReferenceResponse(
            datasetParameters = javaType.datasetParameters().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
