@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Delimited text read settings.
 * @property compressionProperties Compression settings.
 * @property skipLineCount Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType integer).
 * @property type The read setting type.
 * Expected value is 'DelimitedTextReadSettings'.
 */
public data class DelimitedTextReadSettingsResponse(
    public val compressionProperties: Any? = null,
    public val skipLineCount: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DelimitedTextReadSettingsResponse):
            DelimitedTextReadSettingsResponse = DelimitedTextReadSettingsResponse(
            compressionProperties = javaType.compressionProperties().map({ args0 -> args0 }).orElse(null),
            skipLineCount = javaType.skipLineCount().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
