@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Execute data flow activity.
 * @property compute Compute properties for data flow activity.
 * @property continueOnError Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean)
 * @property dataFlow Data flow reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property integrationRuntime The integration runtime reference.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property runConcurrently Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean)
 * @property sourceStagingConcurrency Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
 * @property staging Staging info for execute data flow activity.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property traceLevel Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string)
 * @property type Type of activity.
 * Expected value is 'ExecuteDataFlow'.
 * @property userProperties Activity user properties.
 */
public data class ExecuteDataFlowActivityResponse(
    public val compute: ExecuteDataFlowActivityTypePropertiesResponseCompute? = null,
    public val continueOnError: Any? = null,
    public val dataFlow: DataFlowReferenceResponse,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val integrationRuntime: IntegrationRuntimeReferenceResponse? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val runConcurrently: Any? = null,
    public val sourceStagingConcurrency: Any? = null,
    public val staging: DataFlowStagingInfoResponse? = null,
    public val state: String? = null,
    public val traceLevel: Any? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExecuteDataFlowActivityResponse):
            ExecuteDataFlowActivityResponse = ExecuteDataFlowActivityResponse(
            compute = javaType.compute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ExecuteDataFlowActivityTypePropertiesResponseCompute.Companion.toKotlin(args0)
                })
            }).orElse(null),
            continueOnError = javaType.continueOnError().map({ args0 -> args0 }).orElse(null),
            dataFlow = javaType.dataFlow().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowReferenceResponse.Companion.toKotlin(args0)
            }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            integrationRuntime = javaType.integrationRuntime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runConcurrently = javaType.runConcurrently().map({ args0 -> args0 }).orElse(null),
            sourceStagingConcurrency = javaType.sourceStagingConcurrency().map({ args0 -> args0 }).orElse(null),
            staging = javaType.staging().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowStagingInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            traceLevel = javaType.traceLevel().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
