@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Factory's GitHub repo information.
 * @property accountName Account name.
 * @property clientId GitHub bring your own app client id.
 * @property clientSecret GitHub bring your own app client secret information.
 * @property collaborationBranch Collaboration branch.
 * @property disablePublish Disable manual publish operation in ADF studio to favor automated publish.
 * @property hostName GitHub Enterprise host name. For example: `https://github.mydomain.com`
 * @property lastCommitId Last commit id.
 * @property repositoryName Repository name.
 * @property rootFolder Root folder.
 * @property type Type of repo configuration.
 * Expected value is 'FactoryGitHubConfiguration'.
 */
public data class FactoryGitHubConfigurationResponse(
    public val accountName: String,
    public val clientId: String? = null,
    public val clientSecret: GitHubClientSecretResponse? = null,
    public val collaborationBranch: String,
    public val disablePublish: Boolean? = null,
    public val hostName: String? = null,
    public val lastCommitId: String? = null,
    public val repositoryName: String,
    public val rootFolder: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FactoryGitHubConfigurationResponse):
            FactoryGitHubConfigurationResponse = FactoryGitHubConfigurationResponse(
            accountName = javaType.accountName(),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.GitHubClientSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            collaborationBranch = javaType.collaborationBranch(),
            disablePublish = javaType.disablePublish().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            lastCommitId = javaType.lastCommitId().map({ args0 -> args0 }).orElse(null),
            repositoryName = javaType.repositoryName(),
            rootFolder = javaType.rootFolder(),
            type = javaType.type(),
        )
    }
}
