@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity properties of the factory resource.
 * @property principalId The principal id of the identity.
 * @property tenantId The client tenant id of the identity.
 * @property type The identity type.
 * @property userAssignedIdentities List of user assigned identities for the factory.
 */
public data class FactoryIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, Any>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FactoryIdentityResponse):
            FactoryIdentityResponse = FactoryIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
