@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The location of file server dataset.
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'FileServerLocation'.
 */
public data class FileServerLocationResponse(
    public val fileName: Any? = null,
    public val folderPath: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FileServerLocationResponse):
            FileServerLocationResponse = FileServerLocationResponse(
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
