@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Ftp read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableChunking If true, disable parallel reading within each file. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'FtpReadSettings'.
 * @property useBinaryTransfer Specify whether to use binary transfer mode for FTP stores. Type: boolean (or Expression with resultType boolean).
 * @property wildcardFileName Ftp wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath Ftp wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class FtpReadSettingsResponse(
    public val deleteFilesAfterCompletion: Any? = null,
    public val disableChunking: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val enablePartitionDiscovery: Any? = null,
    public val fileListPath: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val partitionRootPath: Any? = null,
    public val recursive: Any? = null,
    public val type: String,
    public val useBinaryTransfer: Any? = null,
    public val wildcardFileName: Any? = null,
    public val wildcardFolderPath: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FtpReadSettingsResponse):
            FtpReadSettingsResponse = FtpReadSettingsResponse(
            deleteFilesAfterCompletion = javaType.deleteFilesAfterCompletion().map({ args0 ->
                args0
            }).orElse(null),
            disableChunking = javaType.disableChunking().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            enablePartitionDiscovery = javaType.enablePartitionDiscovery().map({ args0 -> args0 }).orElse(null),
            fileListPath = javaType.fileListPath().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            partitionRootPath = javaType.partitionRootPath().map({ args0 -> args0 }).orElse(null),
            recursive = javaType.recursive().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useBinaryTransfer = javaType.useBinaryTransfer().map({ args0 -> args0 }).orElse(null),
            wildcardFileName = javaType.wildcardFileName().map({ args0 -> args0 }).orElse(null),
            wildcardFolderPath = javaType.wildcardFolderPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
