@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Activity to get metadata of dataset
 * @property dataset GetMetadata activity dataset reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property fieldList Fields of metadata to get from dataset.
 * @property formatSettings GetMetadata activity format settings.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storeSettings GetMetadata activity store settings.
 * @property type Type of activity.
 * Expected value is 'GetMetadata'.
 * @property userProperties Activity user properties.
 */
public data class GetMetadataActivityResponse(
    public val dataset: DatasetReferenceResponse,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val fieldList: List<Any>? = null,
    public val formatSettings: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val state: String? = null,
    public val storeSettings: Any? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetMetadataActivityResponse):
            GetMetadataActivityResponse = GetMetadataActivityResponse(
            dataset = javaType.dataset().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
            }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fieldList = javaType.fieldList().map({ args0 -> args0 }),
            formatSettings = javaType.formatSettings().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            storeSettings = javaType.storeSettings().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
