@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Pipeline resource type.
 * @property activities List of activities in pipeline.
 * @property annotations List of tags that can be used for describing the Pipeline.
 * @property concurrency The max number of concurrent runs for the pipeline.
 * @property description The description of the pipeline.
 * @property etag Etag identifies change in the resource.
 * @property folder The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property parameters List of parameters for pipeline.
 * @property policy Pipeline Policy.
 * @property runDimensions Dimensions emitted by Pipeline.
 * @property type The resource type.
 * @property variables List of variables for pipeline.
 */
public data class GetPipelineResult(
    public val activities: List<Any>? = null,
    public val annotations: List<Any>? = null,
    public val concurrency: Int? = null,
    public val description: String? = null,
    public val etag: String,
    public val folder: PipelineResponseFolder? = null,
    public val id: String,
    public val name: String,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val policy: PipelinePolicyResponse? = null,
    public val runDimensions: Map<String, Any>? = null,
    public val type: String,
    public val variables: Map<String, VariableSpecificationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetPipelineResult):
            GetPipelineResult = GetPipelineResult(
            activities = javaType.activities().map({ args0 -> args0 }),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            concurrency = javaType.concurrency().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PipelinePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runDimensions = javaType.runDimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            variables = javaType.variables().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.VariableSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
