@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * HDInsight ondemand linked service.
 * @property additionalLinkedServiceNames Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterNamePrefix The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
 * @property clusterPassword The password to access the cluster.
 * @property clusterResourceGroup The resource group where the cluster belongs. Type: string (or Expression with resultType string).
 * @property clusterSize Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string).
 * @property clusterSshPassword The password to SSH remotely connect cluster’s node (for Linux).
 * @property clusterSshUserName The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
 * @property clusterType The cluster type. Type: string (or Expression with resultType string).
 * @property clusterUserName The username to access the cluster. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property coreConfiguration Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
 * @property credential The credential reference containing authentication information.
 * @property dataNodeSize Specifies the size of the data node for the HDInsight cluster.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property hBaseConfiguration Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
 * @property hcatalogLinkedServiceName The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database as the metastore.
 * @property hdfsConfiguration Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
 * @property headNodeSize Specifies the size of the head node for the HDInsight cluster.
 * @property hiveConfiguration Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
 * @property hostSubscriptionId The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
 * @property linkedServiceName Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
 * @property mapReduceConfiguration Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
 * @property oozieConfiguration Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
 * @property parameters Parameters for linked service.
 * @property scriptActions Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
 * @property servicePrincipalId The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key for the service principal id.
 * @property sparkVersion The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
 * @property stormConfiguration Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
 * @property subnetName The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type: string (or Expression with resultType string).
 * @property tenant The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property timeToLive The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'HDInsightOnDemand'.
 * @property version Version of the HDInsight cluster.  Type: string (or Expression with resultType string).
 * @property virtualNetworkId The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with resultType string).
 * @property yarnConfiguration Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
 * @property zookeeperNodeSize Specifies the size of the Zoo Keeper node for the HDInsight cluster.
 */
public data class HDInsightOnDemandLinkedServiceResponse(
    public val additionalLinkedServiceNames: List<LinkedServiceReferenceResponse>? = null,
    public val annotations: List<Any>? = null,
    public val clusterNamePrefix: Any? = null,
    public val clusterPassword: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val clusterResourceGroup: Any,
    public val clusterSize: Any,
    public val clusterSshPassword: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val clusterSshUserName: Any? = null,
    public val clusterType: Any? = null,
    public val clusterUserName: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val coreConfiguration: Any? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val dataNodeSize: Any? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val hBaseConfiguration: Any? = null,
    public val hcatalogLinkedServiceName: LinkedServiceReferenceResponse? = null,
    public val hdfsConfiguration: Any? = null,
    public val headNodeSize: Any? = null,
    public val hiveConfiguration: Any? = null,
    public val hostSubscriptionId: Any,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val mapReduceConfiguration: Any? = null,
    public val oozieConfiguration: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val scriptActions: List<ScriptActionResponse>? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val sparkVersion: Any? = null,
    public val stormConfiguration: Any? = null,
    public val subnetName: Any? = null,
    public val tenant: Any,
    public val timeToLive: Any,
    public val type: String,
    public val version: Any,
    public val virtualNetworkId: Any? = null,
    public val yarnConfiguration: Any? = null,
    public val zookeeperNodeSize: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HDInsightOnDemandLinkedServiceResponse):
            HDInsightOnDemandLinkedServiceResponse = HDInsightOnDemandLinkedServiceResponse(
            additionalLinkedServiceNames = javaType.additionalLinkedServiceNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            clusterNamePrefix = javaType.clusterNamePrefix().map({ args0 -> args0 }).orElse(null),
            clusterPassword = javaType.clusterPassword().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            clusterResourceGroup = javaType.clusterResourceGroup(),
            clusterSize = javaType.clusterSize(),
            clusterSshPassword = javaType.clusterSshPassword().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            clusterSshUserName = javaType.clusterSshUserName().map({ args0 -> args0 }).orElse(null),
            clusterType = javaType.clusterType().map({ args0 -> args0 }).orElse(null),
            clusterUserName = javaType.clusterUserName().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            coreConfiguration = javaType.coreConfiguration().map({ args0 -> args0 }).orElse(null),
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataNodeSize = javaType.dataNodeSize().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            hBaseConfiguration = javaType.hBaseConfiguration().map({ args0 -> args0 }).orElse(null),
            hcatalogLinkedServiceName = javaType.hcatalogLinkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hdfsConfiguration = javaType.hdfsConfiguration().map({ args0 -> args0 }).orElse(null),
            headNodeSize = javaType.headNodeSize().map({ args0 -> args0 }).orElse(null),
            hiveConfiguration = javaType.hiveConfiguration().map({ args0 -> args0 }).orElse(null),
            hostSubscriptionId = javaType.hostSubscriptionId(),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            mapReduceConfiguration = javaType.mapReduceConfiguration().map({ args0 -> args0 }).orElse(null),
            oozieConfiguration = javaType.oozieConfiguration().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            scriptActions = javaType.scriptActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ScriptActionResponse.Companion.toKotlin(args0)
                })
            }),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            sparkVersion = javaType.sparkVersion().map({ args0 -> args0 }).orElse(null),
            stormConfiguration = javaType.stormConfiguration().map({ args0 -> args0 }).orElse(null),
            subnetName = javaType.subnetName().map({ args0 -> args0 }).orElse(null),
            tenant = javaType.tenant(),
            timeToLive = javaType.timeToLive(),
            type = javaType.type(),
            version = javaType.version(),
            virtualNetworkId = javaType.virtualNetworkId().map({ args0 -> args0 }).orElse(null),
            yarnConfiguration = javaType.yarnConfiguration().map({ args0 -> args0 }).orElse(null),
            zookeeperNodeSize = javaType.zookeeperNodeSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
