@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The role based access control (RBAC) authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'RBAC'.
 * @property credential The credential reference containing authentication information.
 * @property resourceId The resource identifier of the integration runtime to be shared.
 */
public data class LinkedIntegrationRuntimeRbacAuthorizationResponse(
    public val authorizationType: String,
    public val credential: CredentialReferenceResponse? = null,
    public val resourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LinkedIntegrationRuntimeRbacAuthorizationResponse):
            LinkedIntegrationRuntimeRbacAuthorizationResponse =
            LinkedIntegrationRuntimeRbacAuthorizationResponse(
                authorizationType = javaType.authorizationType(),
                credential = javaType.credential().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                resourceId = javaType.resourceId(),
            )
    }
}
