@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Source connection details.
 * @property commonDslConnectorProperties List of name/value pairs for connection properties.
 * @property isInlineDataset A boolean indicating whether linked service is of type inline dataset. Currently only inline datasets are supported.
 * @property linkedService Linked service reference.
 * @property linkedServiceType Type of the linked service e.g.: AzureBlobFS.
 * @property type Type of connection via linked service or dataset.
 */
public data class MapperConnectionResponse(
    public val commonDslConnectorProperties: List<MapperDslConnectorPropertiesResponse>? = null,
    public val isInlineDataset: Boolean? = null,
    public val linkedService: LinkedServiceReferenceResponse? = null,
    public val linkedServiceType: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperConnectionResponse):
            MapperConnectionResponse = MapperConnectionResponse(
            commonDslConnectorProperties = javaType.commonDslConnectorProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperDslConnectorPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            isInlineDataset = javaType.isInlineDataset().map({ args0 -> args0 }).orElse(null),
            linkedService = javaType.linkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceType = javaType.linkedServiceType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
