@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Cursor methods for Mongodb query
 * @property limit Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with resultType integer).
 * @property project Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents, omit this parameter. Type: string (or Expression with resultType string).
 * @property skip Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing paginated results. Type: integer (or Expression with resultType integer).
 * @property sort Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string). Type: string (or Expression with resultType string).
 */
public data class MongoDbCursorMethodsPropertiesResponse(
    public val limit: Any? = null,
    public val project: Any? = null,
    public val skip: Any? = null,
    public val sort: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MongoDbCursorMethodsPropertiesResponse):
            MongoDbCursorMethodsPropertiesResponse = MongoDbCursorMethodsPropertiesResponse(
            limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            skip = javaType.skip().map({ args0 -> args0 }).orElse(null),
            sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
